<?php

// randomly accesses JPG in local directory, outputs EXIF metadata, picture, and camera

$exts = array('jpg');

//collect list of images in current (look) directory
//modification suggested by Kaf Oseo
$url = array();
if($handle = opendir(dirname(__FILE__))) {
        while(false !== ($image = readdir($handle)))
                foreach($exts as $ext)
                        if(strstr($image, '.' . $ext))
                                $url[] = $image;
        closedir($handle);
}

//generate a random number
srand((double)microtime() * 1000000);

// number of images
$ct = count($url);

// random image number
$rn = (rand()%$ct);

// get the image name
$file = trim($url[$rn]);

if (file_exists($file))
   $exif = exif_read_data($file, 0, true) ;
else
 exit("Not a valid file directory and/or file");
echo "$file:<br />\n";
echo "<img src='$file' alt='$file' style='width: 600px' /><br /><br />";

foreach ($exif as $key => $section) {
    foreach ($section as $name => $val) {
        echo "$key.$name: $val<br />\n";
        if ($name == 'Model') {
          $val = str_replace(" ","_",$val);
          echo "<img src='$val.png' alt='$val' /><br /><br />";
        }
    }
}
?>

